package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.balancesimple.request.BindCreditCardRequest;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsByCardInfoMap;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 01.10.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Description("Проверка прав внутренних ролей: позитивные сценарии")
@RunWith(Parameterized.class)
public class DepositByCardRolesNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(0)
    public String operator;

    @Parameterized.Parameter(1)
    public String campaignOwner;

    @Parameterized.Parameters(name = "operator = {0}, login = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.PLACER, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.SUPPORT, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.SUPER_LOGIN, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.MEDIA, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.SUPER_READER, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.AGENCY_RUB, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
                {Logins.MANAGER_DEFAULT, FinanceLogins.DEPOSIT_BY_CARD_CLIENT4},
        });
    }

    private static String customTransactionId;

    @BeforeClass
    public static void prepareData() {
        customTransactionId = randomAlphanumeric(PayCampaignsByCardInfoMap.CUSTOM_TRANSACTION_ID_LENGTH);
    }

    private int accountId;
    private String payMethod;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.userSteps.addModeratedCampaign(campaignOwner);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(campaignOwner);
        accountId = api.as(campaignOwner).userSteps.financeSteps().getAccountID(campaignOwner);
        payMethod = api.userSteps.balanceSimpleSteps().bindCreditCard(new BindCreditCardRequest()
                .defaultCreditCard()).getPaymentMethod();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6025")
    public void requestUsingRole() {
        api.as(operator);
        api.userSteps.financeSteps().shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                new AccountManagementRequestMap<>(api.type())
                        .withAction(Action.DEPOSIT_BY_CARD)
                        .withPayMethodId(payMethod)
                        .withVersion("20502A")
                        .withCustomTransactionId(customTransactionId)
                        .withPayments(new PaymentMap(api.type())
                                .withAccountID(accountId)
                                .withCurrency(Currency.RUB)),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_CONTAIN_FOLLOWING_VALUES,
                        capitalize(AccountManagementRequestMap.ACTION),
                        "Deposit, TransferMoney, Invoice, Get, Update"));
    }
}
