package ru.yandex.autotests.directapi.finance.accountmanagement.depositebycard;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.AccountManagementRequest;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountManagementRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6408
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_DEPOSIT_BY_CARD)
@Issue("https://st.yandex-team.ru/DIRECT-42633")
@Description("Вызов метода, используя API версии 4")
public class DepositByCardVersion4Test {

    private static final String CLIENT = FinanceLogins.DEPOSIT_BY_CARD_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6029")
    public void requestInVersion4() {
        AccountManagementRequest request = (AccountManagementRequest) new AccountManagementRequestMap<>(api.type())
                .withAction(Action.DEPOSIT_BY_CARD)
                .withPayMethodId("invalidLol")
                .withVersion("20502A")
                .withCustomTransactionId("what")
                .withPayments(new PaymentMap(api.type())
                        .withAccountID(1234)
                        .withAmount(300.0f)).getBean();

        api.version(4).userSteps.financeSteps().shouldGetErrorOn(Method.ACCOUNT_MANAGEMENT,
                request,
                new AxisError(509));
    }
}
