package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.comparesEqualTo;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementGetAccountDailyBudgetAmountTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_LOGIN1;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Float amount;

    @Parameterized.Parameter(1)
    public Matcher<Account> accountMatcher;

    private static long accountId;

    @BeforeClass
    public static void init() {
        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][] {
                new Object[] { 0f, hasProperty(AccountMap.ACCOUNT_DAY_BUDGET, nullValue()) },
                new Object[] { 500f, hasProperty(AccountMap.ACCOUNT_DAY_BUDGET,
                        hasProperty(AccountDayBudgetInfoMap.AMOUNT, comparesEqualTo(500f))) },
                new Object[] { 1000f, hasProperty(AccountMap.ACCOUNT_DAY_BUDGET,
                        hasProperty(AccountDayBudgetInfoMap.AMOUNT, comparesEqualTo(1000f))) },
                new Object[] { 2000f, hasProperty(AccountMap.ACCOUNT_DAY_BUDGET,
                        hasProperty(AccountDayBudgetInfoMap.AMOUNT, comparesEqualTo(2000f))) },
        };

        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.userSteps.getDirectJooqDbSteps()
                .campaignsSteps()
                .updateCampaigns(new CampaignsRecord()
                        .with(Campaigns.CAMPAIGNS.CID, accountId)
                        .with(Campaigns.CAMPAIGNS.DAY_BUDGET, BigDecimal.valueOf(amount)));

        assertThat(
                "сумма дневного бюджета, которую записали в базу, вернулась верно",
                api.userSteps.financeSteps().getAccount((int) accountId),
                accountMatcher);
    }

}
