package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOptions;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementGetAccountDailyBudgetEmailNotificationSettingsTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_LOGIN2;
    private static final String FLAG_NAME = "paused_by_day_budget";
    private static final String ANOTHER_FLAG_NAME = "feed_status_change";

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public String flags;

    @Parameterized.Parameter(1)
    public String expectedEmailNotificationSetting;

    private static long accountId;

    @BeforeClass
    public static void init() {
        api.userSteps.campaignSteps().verifyHasNonArchivedCampaign(LOGIN);
        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        final Object[][] result = new Object[][] {
                new Object[] { "", Value.NO },
                new Object[] { FLAG_NAME, Value.YES },
                new Object[] { ANOTHER_FLAG_NAME, Value.NO },
                new Object[] { FLAG_NAME + "," + ANOTHER_FLAG_NAME, Value.YES },
                new Object[] { ANOTHER_FLAG_NAME + "," + FLAG_NAME, Value.YES },
        };
        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                .campaignsSteps()
                .updateCampOptions(new CampOptionsRecord()
                        .with(CampOptions.CAMP_OPTIONS.CID, accountId)
                        .with(CampOptions.CAMP_OPTIONS.EMAIL_NOTIFICATIONS, flags));

        assertThat(
                "настройка email-уведомлений из базы вернулась верно",
                api.userSteps.financeSteps().<Account>getAccount((int) accountId),
                hasProperty("emailNotification",
                        hasProperty("pausedByDayBudget", equalTo(expectedEmailNotificationSetting))));
    }
}
