package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 22.10.13
 */
@RunWith(Parameterized.class)
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementGetCurrencyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameters
    public static Collection roleValues() {
        Object[][] data = new Object[][]{
                {FinanceLogins.MANAGER_LOGIN, FinanceLogins.SERVICED_CLIENT1, Currency.RUB},
                {FinanceLogins.GET_UPDATE_CLIENT_1, FinanceLogins.GET_UPDATE_CLIENT_1, Currency.RUB},
                {FinanceLogins.INVOICE_FREE_CLIENT, FinanceLogins.INVOICE_FREE_CLIENT, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    public AccountManagementGetCurrencyTest(String managerLogin, String clientLogin, Currency currency) {
        api.as(managerLogin);
        this.clientLogin = clientLogin;
        this.currency = currency;
    }

    private String clientLogin;
    private Currency currency;

    @BeforeClass
    public static void initTest() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.addModeratedCampaign(FinanceLogins.SERVICED_CLIENT1);
        api.userSteps.financeSteps().verifySharedAccount(FinanceLogins.SERVICED_CLIENT1);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.GET_UPDATE_CLIENT_1);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6030")
    public void checkCurrencyTest() {
        Account account = api.userSteps.financeSteps().getAccount(clientLogin);
        String cur = currency.equals(Currency.YND_FIXED) ? null : currency.toString();
        assertThat("Не совпала валюта кошелька", account.getCurrency(), equalTo(cur));
    }
}
