package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: rockman
 * Date: 13.11.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementGetLimitTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TRANSFER_1;
    private static final String CLIENT_LOGIN_1 = FinanceLogins.TRANSFER_CLIENT_1;
    private static final int LIMIT_COUNT = 51;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private String[] logins = new String[LIMIT_COUNT];

    @Before
    public void setLogins() {
        for (int i = 0; i < LIMIT_COUNT; i++) {
            logins[i] = CLIENT_LOGIN_1;
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6031")
    public void checkGetResponse() {
        api.userSteps.financeSteps().shouldGetErrorOnAccountManagementGet(logins, null,
                new AxisError(241,
                        AxisErrorDetails.THE_SELECTIONCRITERIA_LOGIN_ARRAY_MUST_CONTAIN_NO_MORE_THAN_50_ELEMENTS));
    }
}
