package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.ArrayUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 27.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@RunWith(Parameterized.class)
public class AccountManagementGetMassShardingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientFirstShard;

    @Parameterized.Parameter(value = 2)
    public String clientSecondShard;

    @Parameterized.Parameters(name = "Operator = {0}, ClientFirstShard = {1}, ClientSecondShard = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.ACCOUNT_SUBCLIENT_SHARD1, Logins.ACCOUNT_SUBCLIENT_SHARD},
                {Logins.AGENCY_YE_DEFAULT, FinanceLogins.AGENCY_AND_FREE_CLIENT_YE, Logins.ACCOUNT_SUBCLIENT_SHARD2}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_SHARD_2);
        api.as(Logins.AGENCY_SHARD_2).userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD);
        api.userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD1);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD1, ShardNumbers.DEFAULT_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6032")
    public void accountManagementGetTest() {
        //получение аккаунта по логину
        Account[] accounts = ((AccountManagementResponse) api.as(operator).userSteps.financeSteps()
                .get(new String[]{clientFirstShard, clientSecondShard}, null)).getAccounts();
        Integer[] accountIDs = extract(accounts, on(Account.class).getAccountID()).toArray(new Integer[]{});
        //получение аккаунта по accountID
        accounts = ((AccountManagementResponse) api.userSteps.financeSteps().get(
                null, ArrayUtils.toPrimitive(accountIDs))).getAccounts();
        assertThat("Вернулся неправильный аккаунт", extract(accounts, on(Account.class).getLogin()),
                anyOf(hasItem(equalTo(clientFirstShard)), hasItem(equalTo(clientSecondShard))));
    }
}
