package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 20.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@RunWith(Parameterized.class)
public class AccountManagementGetShardingNegativeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public String accountOwner;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, FinanceLogins.AGENCY_AND_FREE_CLIENT_YE, Logins.AGENCY_YE_DEFAULT},
                {Logins.AGENCY_YE_DEFAULT, Logins.ACCOUNT_SUBCLIENT_SHARD, Logins.AGENCY_SHARD_2}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_SHARD_2);
        api.as(Logins.AGENCY_SHARD_2).userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6034")
    public void accountManagementGetAccountIDTest() {
        int accountID = api.as(accountOwner).userSteps.financeSteps().getAccountID(client);
        api.as(operator).userSteps.financeSteps()
                .shouldGetErrorsOnAccountManagementGet(accountID, new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6033")
    public void accountManagementGetLoginTest() {
        api.as(operator).userSteps.financeSteps()
                .shouldGetErrorsOnAccountManagementGet(client,
                        new AxisError(54, AxisErrorDetails.NOT_AN_AGENCY_CLIENT));
    }
}
