package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Author pavryabov
 * Date 10.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class AccountManagementGetWithoutCampaigns {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6036")
    public void getErrorRequestWithAccountWithoutCampaignsAgencyCall() {
        api.as(FinanceLogins.AGENCY_TRANSFER_1).wsdl(APIPort_PortType.class);
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createNewAgencySubClient("subClient", FinanceLogins.AGENCY_TRANSFER_1);
        String subclient = createNewSubclientResponse.getLogin();
        api.clientLogin(subclient);
        long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int accountID = api.userSteps.financeSteps().enableAndGetSharedAccount(subclient);
        api.userSteps.campaignSteps().campaignsDelete(campaignID);
        api.userSteps.financeSteps().shouldGetErrorsOnAccountManagementGet(
                accountID, new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
