package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * User: rockman
 * Date: 18.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class AgencyWithoutRightsTest {

    private static final String AGENCY_LOGIN = Logins.AGENCY_EUR;
    private static final String REP_LOGIN = Logins.AGENCY_EUR_REP;
    private static final String CLIENT_LOGIN = Logins.SUBCLIENT_EUR;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6046")
    public void shouldNotGetErrorNoRightsForClientRep() {
        //https://st.yandex-team.ru/DIRECT-59393
        api.as(REP_LOGIN).userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{CLIENT_LOGIN}, null,
                        new AxisError(515, AxisErrorDetails.NULL_STRING));
    }

    @Test
    public void repShouldGetErrorForNotBelongedSubclient() {
        // Проверяем если у сабклиента подключен ОС, но к клиенту нет доступа у ограниченного представителя
        // то мы не сможем получить информацию по ОС
        api.as(AGENCY_LOGIN);
        CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createNewAgencySubClient("at-sa-", AGENCY_LOGIN);
        final String subClientLogin = subClient.getLogin();
        api.userSteps.campaignSteps().addDefaultTextCampaign(subClientLogin);
        api.userSteps.financeSteps().verifySharedAccount(subClientLogin);
        Account account = api.userSteps.financeSteps().getAccount(subClientLogin);
        assumeThat("вернулась информация по ОС", account, notNullValue());

        api.as(REP_LOGIN).userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{subClientLogin}, null,
                        new AxisError(54, AxisErrorDetails.YOU_ARE_NOT_AUTHORIZED_TO_VIEW_THE_REQUESTED_INFORMATION));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6046")
    public void shouldNotGetErrorNoRightsForMainRep() {
        api.as(AGENCY_LOGIN).userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{CLIENT_LOGIN}, null,
                        new AxisError(515, AxisErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6047")
    public void shouldGetErrorForAgent() {
        //https://jira.yandex-team.ru/browse/DIRECT-28459
        api.as(Logins.SUPER_LOGIN, "dimaxsuper").userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{"dimaxsuper"}, null,
                        new AxisError(515, AxisErrorDetails.NULL_STRING));
    }
}
