package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 07.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ClientAccountManagementGetTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameters
    public static Collection roleValues() {
        Object[][] data = new Object[][]{
                {FinanceLogins.GET_UPDATE_CLIENT_1},
                {FinanceLogins.INVOICE_FREE_CLIENT},
        };
        return Arrays.asList(data);
    }

    public ClientAccountManagementGetTest(String clientLogin) {
        this.clientLogin = clientLogin;
        api.as(clientLogin);
    }

    private String clientLogin;

    @BeforeClass
    public static void initTest() {
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.GET_UPDATE_CLIENT_1);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(FinanceLogins.DEPOSIT_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.DEPOSIT_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.DEPOSIT_FREE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6048")
    public void getRequest() {
        AccountManagementResponse response = api.userSteps.financeSteps().get(null, new int[]{});
        assertThat(response.getAccounts().length, equalTo(1));
        assertThat(response.getAccounts()[0].getLogin(), equalTo(clientLogin));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6051")
    public void getRequestBySelfLoginAndAccountId() {
        AccountManagementResponse response = api.userSteps.financeSteps().get(new String[]{clientLogin}, null);
        assertThat(response.getAccounts().length, equalTo(1));
        assertThat(response.getAccounts()[0].getLogin(), equalTo(clientLogin));
        response = api.userSteps.financeSteps().get(null, new int[]{response.getAccounts()[0].getAccountID()});
        assertThat(response.getAccounts().length, equalTo(1));
        assertThat(response.getAccounts()[0].getLogin(), equalTo(clientLogin));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6049")
    public void withAnotherLogin() {
        api.userSteps.financeSteps()
                .shouldGetErrorOnAccountManagementGet(new String[]{"at-direct-c-full"}, null,
                        new AxisError(54, AxisErrorDetails.NO_RIGHTS_FOR_USE_LOGIN));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6050")
    public void withAnotherAccountId() {
        String noRightLogin = FinanceLogins.DEPOSIT_FREE_CLIENT;
        int accountID = api.as(noRightLogin).userSteps.financeSteps().getAccountID(noRightLogin);
        api.as(clientLogin).userSteps.financeSteps()
                .shouldGetErrorsOnAccountManagementGet(accountID, new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
