package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.finance.FinanceLogins.AGENCY_ENABLE_SHARED_ACCOUNT;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Feature(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-65568")
public class ClientWithAgencyAccountOnlyTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final AxisError CLIENT_HAS_NO_CLIENT_SHARED_ACCOUNT_ERROR = new AxisError(515);

    public static String agencyLogin = AGENCY_ENABLE_SHARED_ACCOUNT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    public static int agencyAccountID;
    public static String clientLogin;

    @BeforeClass
    public static void sharedAccountFlagOn() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);

        api.as(agencyLogin);
        CreateNewSubclientResponse subClient = api.userSteps.clientSteps()
                .createNewAgencySubClient("create", agencyLogin, Currency.RUB);
        clientLogin = subClient.getLogin();

        api.userSteps.addDraftCampaign(clientLogin);
        api.userSteps.createAccount(clientLogin);
        api.userSteps.clientFakeSteps().enableAPI(clientLogin);
        agencyAccountID = api.userSteps.financeSteps().getAccountID(clientLogin);
        api.as(Logins.SUPER_LOGIN, clientLogin);
    }

    @Test
    public void shouldGetAgencyAccountOnlyWithNoErrors() {
        AccountManagementResponse response = api.userSteps.financeSteps().get(null, null);

        assumeThat("В ответе отсутствуют ошибки",
                response.getActionsResult(), arrayWithSize(0));
        assumeThat("Вернулся единственный счёт",
                response.getAccounts(), arrayWithSize(1));

        assertThat("Счёт агентский",
                response.getAccounts()[0].getAccountID(), equalTo(agencyAccountID));
    }

    @Test
    public void shouldClientGetEmptyClientSharedAccountsList() {
        api.userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{clientLogin}, null,
                        CLIENT_HAS_NO_CLIENT_SHARED_ACCOUNT_ERROR);
    }

    @Test
    public void shouldIgnoreCaseOfLoginString() {
        String clientLoginUpperCase = clientLogin.toUpperCase();

        api.userSteps.financeSteps()
                .shouldGetMultipleErrorOnAccountManagementGet(new String[]{clientLoginUpperCase}, null,
                        CLIENT_HAS_NO_CLIENT_SHARED_ACCOUNT_ERROR);
    }

}
