package ru.yandex.autotests.directapi.finance.accountmanagement.get;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;


/**
 * User: pavryabov
 * Date: 25.12.13
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1381
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class ClientWithAgencyAndSelfAccountsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    public static int agencyAccountID;
    public static String clientLogin = FinanceLogins.TRANSFER_CLIENT_6;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_TRANSFER_1);
        api.as(FinanceLogins.AGENCY_TRANSFER_1).userSteps.createAccount(clientLogin);
        agencyAccountID = api.userSteps.financeSteps().getAccountID(clientLogin);
        api.userSteps.clientFakeSteps().enableAPI(clientLogin);
        api.userSteps.clientFakeSteps().enableToCreateSelfCampaigns(clientLogin);
        api.as(Logins.SUPER_LOGIN).userSteps.createAccountForFreeClient(clientLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6056")
    public void accountManagementGetWithCampaignEditRight() {
        api.as(FinanceLogins.AGENCY_TRANSFER_1);
        api.userSteps.clientFakeSteps().enableAllowEditCampaigns(clientLogin);
        api.as(clientLogin);
        AccountManagementResponse response = api.userSteps.financeSteps().get(null, null);

        assertThat("Вернулось два счёта", response.getAccounts(), arrayWithSize(2));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6057")
    public void accountManagementGetWithoutCampaignEditRight() {
        api.as(FinanceLogins.AGENCY_TRANSFER_1);
        api.userSteps.clientFakeSteps().disableAllowEditCampaigns(clientLogin);
        api.as(clientLogin);
        AccountManagementResponse response = api.userSteps.financeSteps().get(null, null);

        assertThat("Вернулось два счёта", response.getAccounts(), arrayWithSize(2));

    }

    @Test
    public void accountManagementGetWithoutCampaignEditRightFields() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.clientFakeSteps().disableAllowEditCampaigns(clientLogin);
        api.as(clientLogin);
        AccountManagementResponse response = api.userSteps.financeSteps().get(null, null);
        for (Account account : response.getAccounts()) {
            if (account.getAccountID() == agencyAccountID) {

                assertThat("Вернулись только ожидаемые поля",
                        account,
                        beanDiffer(new Account(
                                "тестовое агентство (transfer money)",
                                agencyAccountID, null, new Float(0), null, null, clientLogin,
                                null, null, null
                        ))
                );
            }
        }
    }

    @Test
    public void shouldIgnoreCaseOfLoginString() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.clientFakeSteps().enableAllowEditCampaigns(clientLogin);
        api.as(clientLogin);
        String clientLoginUpperCase = clientLogin.toUpperCase();
        AccountManagementResponse response = api.userSteps.financeSteps()
                .get(new String[]{clientLoginUpperCase}, null);

        assumeThat("Ошибок не получено",
                response.getActionsResult(), arrayWithSize(0));

        assertThat("Получен единственный клиентский счёт",
                response.getAccounts(), arrayWithSize(1));
    }
}
