package ru.yandex.autotests.directapi.finance.accountmanagement.invoice;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PaymentMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 27.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_INVOICE)
@RunWith(Parameterized.class)
public class AccountManagementInvoiceMassShardingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientFirstShard;

    @Parameterized.Parameter(value = 2)
    public String clientSecondShard;

    @Parameterized.Parameters(name = "Operator = {0}, ClientFirstShard = {1}, ClientSecondShard = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.ACCOUNT_SUBCLIENT_SHARD1, Logins.ACCOUNT_SUBCLIENT_SHARD},
        };
        return Arrays.asList(data);
    }

    public Account accountFirstShard;
    public Account accountSecondShard;
    public Currency currency;
    public Money amount;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_SHARD_2);
        api.as(Logins.AGENCY_SHARD_2).userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD);
        api.userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD1);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD1, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void initTest() {
        accountFirstShard = api.as(operator).userSteps.financeSteps().getAccount(clientFirstShard);
        accountSecondShard = api.userSteps.financeSteps().getAccount(clientSecondShard);
        currency = Currency.getFor(accountFirstShard.getCurrency());
        amount = MoneyCurrency.get(currency).getMinInvoiceAmount();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6059")
    public void accountManagementInvoiceTest() {
        String[] requerstIDs = api.userSteps.financeSteps().getInvoiceRequestIDs(
                new PaymentMap(api.type())
                        .withAccountID(accountFirstShard.getAccountID())
                        .withCurrency(currency)
                        .withAmount(amount.addVAT().floatValue()),
                new PaymentMap(api.type())
                        .withAccountID(accountSecondShard.getAccountID())
                        .withCurrency(currency)
                        .withAmount(amount.addVAT().floatValue())
        );
        for (String requestID : requerstIDs) {
            api.userSteps.balanceSteps().operator(User.get(operator))
                    .requestAmountShouldBe(requestID,
                            IsEqual.equalTo(amount.convert(Currency.RUB).addVAT().floatValue()));
        }
    }
}
