package ru.yandex.autotests.directapi.finance.accountmanagement.invoice;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 22.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_INVOICE)
@RunWith(Parameterized.class)
public class AccountManagementInvoiceShardingPositiveTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public String accountOwner;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2, Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2,
                        Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2},
                {Logins.AGENCY_SHARD_2, Logins.ACCOUNT_SUBCLIENT_SHARD, Logins.AGENCY_SHARD_2},
                {Logins.AGENCY_SHARD_2, Logins.ACCOUNT_SUBCLIENT_SHARD1, Logins.AGENCY_SHARD_2},
                {Logins.MANAGER_DEFAULT, Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2,
                        Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2}
        };
        return Arrays.asList(data);
    }

    public Account account;
    public Currency currency = null;
    public Money amount;

    @BeforeClass
    public static void reshard() {
        api.as(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2).userSteps.addModeratedCampaign();
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps()
                .verifySharedAccount(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2);
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_SHARD_2);
        api.as(Logins.AGENCY_SHARD_2).userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD);
        api.userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD1);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD1, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initTest() {
        account = api.as(accountOwner).userSteps.financeSteps().getAccount(client);
        currency = Currency.getFor(account.getCurrency());
        amount = MoneyCurrency.get(currency).getMinInvoiceAmount();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6061")
    public void accountManagementInvoiceTest() {
        String requestID = api.as(operator).userSteps.financeSteps()
                .getInvoiceRequestID(account.getAccountID(), amount.addVAT().floatValue(), currency);
        api.userSteps.balanceSteps().operator(User.get(accountOwner))
                .requestAmountShouldBe(requestID, IsEqual.equalTo(amount.convert(Currency.RUB).addVAT().floatValue()));
    }
}
