package ru.yandex.autotests.directapi.finance.accountmanagement.invoice;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: mariabye
 * Date: 11.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_INVOICE)
@Tag(TagDictionary.TRUNK)
public class InvoiceClientAccountAccountIDTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static String login = FinanceLogins.INVOICE_FREE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Money minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();
    int accountID = api.userSteps.financeSteps().getAccountID(login);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_INVOICE_1);
        api.as(FinanceLogins.AGENCY_INVOICE_1).userSteps.createAccount(FinanceLogins.INVOICE_SC_1);
        api.as(login).userSteps.addModeratedCampaign(login);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(login);
        api.as(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6077")
    public void invoiceForAccount() {
        String requestID = api.userSteps.financeSteps()
                .getInvoiceRequestID(accountID, minInvoiceAmount.floatValue(), Currency.RUB);
        api.userSteps.balanceSteps().operator(User.get(login))
                .requestAmountShouldBe(requestID, equalTo(minInvoiceAmount.floatValue()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6078")
    public void invoiceForOAccountID() {
        api.userSteps.financeSteps()
                .shouldGetErrorsOnAMInvoice(0, minInvoiceAmount.floatValue(), Currency.RUB,
                        new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6079")
    public void invoiceForNegativeAccountID() {
        api.userSteps.financeSteps()
                .shouldGetErrorOnAMInvoice(-accountID, minInvoiceAmount.floatValue(), Currency.RUB,
                        new AxisError(71,
                                AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
                                "Payments[0].AccountID"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6080")
    public void invoiceForAccountIDNoRight() {
        api.as(FinanceLogins.AGENCY_INVOICE_1);
        int accountID = api.userSteps.financeSteps().getAccountID(FinanceLogins.INVOICE_SC_1);
        api.as(login).userSteps.financeSteps()
                .shouldGetErrorsOnAMInvoice(accountID, minInvoiceAmount.floatValue(), Currency.RUB,
                        new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6081")
    public void invoiceForCampaignIDInsteadOfAccountID() {
        long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.financeSteps()
                .shouldGetErrorsOnAMInvoice(campaignID, minInvoiceAmount.floatValue(), Currency.RUB,
                        new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
