package ru.yandex.autotests.directapi.finance.accountmanagement.invoice;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * User: mariabye
 * Date: 10.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_INVOICE)
@Tag(TagDictionary.TRUNK)
public class InvoiceForClientWithNoAccountTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(FinanceLogins.CLIENT_NO_ACCOUNT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6088")
    public void createInvoiceWithCampaignID() {
        long campaignID =
                api.as(FinanceLogins.MANAGER_LOGIN).userSteps.addDraftCampaign(FinanceLogins.CLIENT_NO_ACCOUNT);
        api.userSteps.financeSteps().shouldGetErrorsOnAMInvoice(
                campaignID, MoneyCurrency.get(null).getMinInvoiceAmount().floatValue(), Currency.YND_FIXED,
                new AxisError(54, AxisErrorDetails.EMPTY_STRING));
    }
}
