package ru.yandex.autotests.directapi.finance.accountmanagement.transfer;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 18.10.13
 * <p/>
 * https://jira.yandex-team.ru/browse/TESTIRT-568
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_TRANSFER)
@Tag(TagDictionary.TRUNK)
public class TransferMoneyCurrencyTest {
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String ACCOUNT_CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT2;
    private static final String ACCOUNT_CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT3;
    private static final float SUM_FOR_CREATE = 2000f;
    private static final Money SUM_FOR_TRANSFER = Money.valueOf(1000L, Currency.RUB);

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных")
    public static void getAccountId() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_LOGIN);
        api.as(AGENCY_LOGIN).userSteps.addAccountWithMoney(ACCOUNT_CLIENT_LOGIN1, SUM_FOR_CREATE, Currency.RUB);
        api.userSteps.createAccount(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.financeSteps().verifyAccountExistsInBalance(ACCOUNT_CLIENT_LOGIN2);
        api.as(AGENCY_LOGIN);
        api.userSteps.addActiveCampaign(ACCOUNT_CLIENT_LOGIN1, SUM_FOR_CREATE, Currency.RUB);
        Account accountFrom = api.userSteps.financeSteps().getAccount(ACCOUNT_CLIENT_LOGIN1);
        api.userSteps.financeSteps().verifyAccountExistsInBalance(ACCOUNT_CLIENT_LOGIN1);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.financeSteps().accountAmountChanged(accountFrom));
    }

    public TransferMoneyCurrencyTest() {
        api.as(AGENCY_LOGIN);
    }

    //Валидный запрос. Проверка переноса.
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6099")
    public void transferBetweenClientsWithAccountsRUB() {
        api.userSteps.transferAndCheck(ACCOUNT_CLIENT_LOGIN1, ACCOUNT_CLIENT_LOGIN2, SUM_FOR_TRANSFER);
    }
}
