package ru.yandex.autotests.directapi.finance.accountmanagement.transfer;

import java.math.RoundingMode;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-72606
 * Перенос всех денег с кошелька (меньше минимальной суммы) - доступен если кампании остановлены
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_TRANSFER)
public class TransferMoneyFromWalletSumThatLessThanMinTransferTest {
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final Currency AGENCY_CURRENCY = Currency.RUB;
    private static final Money SUM_FOR_CREATE = MoneyCurrency.get(AGENCY_CURRENCY).getMinInvoiceAmount().multiply(10);
    private static final Money SUM_FOR_SPENT =
            MoneyCurrency.get(AGENCY_CURRENCY).getMinTransferAmount().multiply(-1).add(SUM_FOR_CREATE).add(5);

    private static String loginFrom;
    private static String loginTo;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных")
    public static void prepareAccounts() {
        CreateNewSubclientResponse firstSubclientResponse =
                api.userSteps.clientSteps().createNewAgencySubClient("subClient", AGENCY_LOGIN, AGENCY_CURRENCY);
        loginFrom = firstSubclientResponse.getLogin();
        Long campaignId = api.userSteps.addActiveCampaign(loginFrom, 1);
        Account accountFrom = api.userSteps.enableAndGetAccount(loginFrom);
        api.userSteps.payAccountWithBalance(loginFrom, SUM_FOR_CREATE.floatValue(), AGENCY_CURRENCY);
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.financeSteps().accountAmountChanged(accountFrom));
        api.userSteps.balanceSteps().doCampaigns(campaignId, SUM_FOR_SPENT.floatValue());
        api.userSteps.balanceSteps().synchronizeCompletionQty(campaignId);
        api.userSteps.campaignFakeSteps().makeCampaignStopped(campaignId);

        CreateNewSubclientResponse secondSubclientResponse =
                api.userSteps.clientSteps().createNewAgencySubClient("subClient", AGENCY_LOGIN, AGENCY_CURRENCY);
        loginTo = secondSubclientResponse.getLogin();
        api.userSteps.createAccount(loginTo);
    }

    @Test
    public void test() {
        Money sumForTransfer = SUM_FOR_CREATE.subtract(SUM_FOR_SPENT).subtractVAT().setScale(2, RoundingMode.HALF_UP);
        Account from = api.userSteps.financeSteps().getAccount(loginFrom);
        assumeThat("К переносу доступна вся сумма", from.getAmountAvailableForTransfer(),
                equalTo(sumForTransfer.floatValue()));

        api.userSteps.transferAndCheck(loginFrom, loginTo, sumForTransfer);
    }
}
