package ru.yandex.autotests.directapi.finance.accountmanagement.transfer;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_TRANSFER)
public class YFTest {

    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TMONEY;
    private static final String ACCOUNT_CLIENT_LOGIN1 = FinanceLogins.TMONEY_CLIENT2;
    private static final String ACCOUNT_CLIENT_LOGIN2 = FinanceLogins.TMONEY_CLIENT3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    public void transferMoneyYndFixedCurrencyTest() {
        int accountId1 = api.userSteps.financeSteps().getAccountID(ACCOUNT_CLIENT_LOGIN1);
        int accountId2 = api.userSteps.financeSteps().getAccountID(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.financeSteps().expectErrorOnTransfer(accountId1, accountId2, 1000.0f, Currency.YND_FIXED.value(),
                new AxisError(245));
    }

    @Test
    public void transferMoneyNullCurrencyTest() {
        int accountId1 = api.userSteps.financeSteps().getAccountID(ACCOUNT_CLIENT_LOGIN1);
        int accountId2 = api.userSteps.financeSteps().getAccountID(ACCOUNT_CLIENT_LOGIN2);
        api.userSteps.financeSteps().expectErrorOnTransfer(accountId1, accountId2, 1000.0f, null, new AxisError(245));
    }
}
