package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.common.SpendMode;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.comparesEqualTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementUpdateAccountDailyBudgetAmountTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_LOGIN5;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);
    private static long accountId;
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter
    public Float amount;

    @BeforeClass
    public static void init() {
        // У клиента должна быть хотя бы одна кампания, кроме кошелька
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(LOGIN);
        if (campaigns.size() == 0) {
            api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.TEXT);
        }

        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        final Float[] amounts = new Float[]{0f, 1000f, 2000f};
        return Arrays.stream(amounts)
                .map(amount -> new Object[]{amount})
                .collect(Collectors.toList());
    }

    @Test
    public void test() {
        AccountMap account = new AccountMap(api.type())
                .withAccountID((int) accountId)
                .withAccountDayBudget(new AccountDayBudgetInfoMap(api.type())
                        .withSpendMode(SpendMode.STRETCHED.getValue())
                        .withAmount(amount));

        api.userSteps.campaignFakeSteps().setDayBudgetChangeCount((int) accountId, 0);
        api.userSteps.financeSteps().update(account);

        assertThat(
                "сумма дневного бюджета сохранилась верно",
                api.userSteps.getDirectJooqDbSteps()
                        .useShardForLogin(LOGIN)
                        .campaignsSteps()
                        .getCampaignById(accountId)
                        .getDayBudget(),
                comparesEqualTo(BigDecimal.valueOf(amount)));
    }

}
