package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.common.api45.AccountDayBudgetInfo;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.common.SpendMode;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementUpdateAccountDailyBudgetNoDailyBudgetTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_LOGIN10;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);
    private static long accountId;
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter
    public String description;
    @Parameterized.Parameter(1)
    public AccountDayBudgetInfo accountDayBudgetInfo;

    @BeforeClass
    public static void init() {
        // У клиента должна быть хотя бы одна кампания, кроме кошелька
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(LOGIN);
        if (campaigns.size() == 0) {
            api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.TEXT);
        }

        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        Object[][] result = new Object[][]{
                new Object[]{"1000/Default",
                        new AccountDayBudgetInfoMap<>(api.type())
                                .withAmount(1000f)
                                .withSpendMode(SpendMode.DEFAULT.getValue())
                                .getBean()},
                new Object[]{"2000/Stretched",
                        new AccountDayBudgetInfoMap<>(api.type())
                                .withAmount(2000f)
                                .withSpendMode(SpendMode.STRETCHED.getValue())
                                .getBean()},
        };
        return Arrays.asList(result);
    }

    @Test
    public void test() {
        api.userSteps.campaignFakeSteps().setDayBudgetChangeCount((int) accountId, 0);
        api.userSteps.financeSteps().update(
                new AccountMap(api.type())
                        .withAccountID((int) accountId)
                        .withAccountDayBudget(new AccountDayBudgetInfoMap<>(accountDayBudgetInfo)));

        assumeThat(
                "настройки дневного бюджета сохранились",
                api.userSteps.financeSteps().getAccount((int) accountId),
                hasProperty(AccountMap.ACCOUNT_DAY_BUDGET, beanDiffer(accountDayBudgetInfo)));

        api.userSteps.financeSteps().update(
                new AccountMap(api.type())
                        .withAccountID((int) accountId)
                        .withAccountDayBudget(null));

        assertThat(
                "настройки дневного бюджета от запроса без accountDayBudget не поменялись",
                api.userSteps.financeSteps().getAccount((int) accountId),
                hasProperty(AccountMap.ACCOUNT_DAY_BUDGET, beanDiffer(accountDayBudgetInfo)));

    }
}
