package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.campaigns.SmsNotificationInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementUpdateAccountDailyBudgetSmsNotificationSettingsTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_LOGIN7;
    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);
    private static final String FLAG_NAME = "paused_by_day_budget_sms";
    private static long accountId;
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter
    public String value;
    @Parameterized.Parameter(1)
    public Matcher<String> smsFlagsMatcher;

    @BeforeClass
    public static void init() {
        // У клиента должна быть хотя бы одна кампания, кроме кошелька
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(LOGIN);
        if (campaigns.size() == 0) {
            api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.TEXT);
        }

        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        Object[][] parameters = new Object[][]{
                new Object[]{Value.YES, containsString(FLAG_NAME)},
                new Object[]{Value.NO, not(containsString(FLAG_NAME))},
        };
        return Arrays.asList(parameters);
    }

    @Test
    public void test() {
        AccountMap account = new AccountMap(api.type())
                .withAccountID((int) accountId)
                .withSmsNotification(new SmsNotificationInfoMap(api.type()).on().withPausedByDayBudgetSms(value));

        api.userSteps.financeSteps().update(account);

        assertThat(
                "настройка SMS-уведомлений сохранилась верно",
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                        .campaignsSteps()
                        .getCampOptionsById(accountId)
                        .getSmsFlags(),
                smsFlagsMatcher);

    }
}
