package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.CampOptions;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Campaigns;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.darkside.Logins;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.common.SpendMode;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountDayBudgetInfoMap;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;

import static org.hamcrest.Matchers.comparesEqualTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
public class AccountManagementUpdateAccountDailyBudgetStopTimeTest {
    private static final String LOGIN = FinanceLogins.ACCOUNT_DAILY_BUDGET_REGULAR_CLIENT_LOGIN;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_SUPER, LOGIN);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Float amount;

    private static long accountId;

    @BeforeClass
    public static void init() {
        api.userSteps.financeSteps().verifySharedAccount(LOGIN);
        accountId = api.userSteps.financeSteps().getAccountID(LOGIN);
    }

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> parameters() {
        final Float[] amounts = new Float[] { 0f, 1f, 2f };
        return Arrays.stream(amounts)
                .map(amount -> new Object[] { amount })
                .collect(Collectors.toList());
    }

    @Before
    public void setUp() {
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN);

        Long clientId = jooqDbSteps.usersSteps().getUser(LOGIN).getClientid();
        accountId = jooqDbSteps.campaignsSteps().getWallet(clientId).getCid();

        jooqDbSteps.campaignsSteps()
                .updateCampaigns(new CampaignsRecord()
                        .with(Campaigns.CAMPAIGNS.CID, accountId)
                        .with(Campaigns.CAMPAIGNS.DAY_BUDGET, BigDecimal.TEN));
        jooqDbSteps.campaignsSteps()
                .updateCampOptions(new CampOptionsRecord()
                        .with(CampOptions.CAMP_OPTIONS.CID, accountId)
                        .with(CampOptions.CAMP_OPTIONS.DAY_BUDGET_STOP_TIME, Timestamp.valueOf("2019-01-01 00:00:00")));
    }

    @Test
    public void testDailyBudgetStopTimeChanged() {
        AccountMap account = new AccountMap(api.type())
                .withAccountID((int) accountId)
                .withAccountDayBudget(new AccountDayBudgetInfoMap(api.type())
                        .withSpendMode(SpendMode.STRETCHED.getValue()));

        api.userSteps.financeSteps().update(account);

        assertThat(
                "время приостановки кампании изменилось",
                api.userSteps.getDirectJooqDbSteps()
                        .useShardForLogin(LOGIN)
                        .campaignsSteps()
                        .getCampOptionsById(accountId)
                        .getDayBudgetStopTime(),
                nullValue());
    }

}
