package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.converter.BeanToBeanMapConverter;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.AccountActionResult;
import ru.yandex.autotests.directapi.common.api45.AccountManagementResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.convert;
import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 27.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@RunWith(Parameterized.class)
public class AccountManagementUpdateMassShardingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientFirstShard;

    @Parameterized.Parameter(value = 2)
    public String clientSecondShard;

    @Parameterized.Parameters(name = "Operator = {0}, ClientFirstShard = {1}, ClientSecondShard = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.ACCOUNT_SUBCLIENT_SHARD1, Logins.ACCOUNT_SUBCLIENT_SHARD},
        };
        return Arrays.asList(data);
    }

    public AccountMap[] accountMaps;
    public Account[] accounts;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(Logins.AGENCY_SHARD_2);
        api.as(Logins.AGENCY_SHARD_2).userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD);
        api.userSteps.createAccount(Logins.ACCOUNT_SUBCLIENT_SHARD1);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SUBCLIENT_SHARD1, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void initTest() {
        accounts = ((AccountManagementResponse) api.as(operator).userSteps.financeSteps()
                .get(new String[]{clientFirstShard, clientSecondShard}, null)).getAccounts();
        accountMaps = (AccountMap[]) convert(accounts,
                new BeanToBeanMapConverter<AccountMap>(AccountMap.class))
                .toArray(new AccountMap(api.type()).emptyArray());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6121")
    public void accountManagementUpdateTest() {
        AccountManagementResponse response =
                api.userSteps.financeSteps().update(accountMaps);
        List<Integer> accountIDs = extract(accounts, on(Account.class).getAccountID());
        assertThat("В ответе метода вернулся неправильный аккаунт",
                extract(response.getActionsResult(), on(AccountActionResult.class).getAccountID()),
                equalTo(accountIDs));
    }
}
