package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 22.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1429
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@RunWith(Parameterized.class)
public class AccountManagementUpdateShardingNegativeTestFailed {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public String accountOwner;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.SUPER_READER, Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2, Logins.MANAGER_DEFAULT}
        };
        return Arrays.asList(data);
    }

    public Account account;

    @BeforeClass
    public static void reshard() {
        api.as(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2).userSteps.addModeratedCampaign();
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps()
                .verifySharedAccount(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2);
        api.userSteps.clientFakeSteps()
                .reshardUserWithLock(Logins.ACCOUNT_SERVICED_CLIENT_SHARD_2, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initTest() {
        account = api.as(accountOwner).userSteps.financeSteps().getAccount(client);
    }

    @Test
    @Title("Bug DIRECT-28226")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6123")
    public void accountManagementUpdateTest() {
        //https://jira.yandex-team.ru/browse/DIRECT-28226
        api.as(operator).userSteps.financeSteps()
                .shouldGetErrorOnUpdateAccount(
                        new AxisError(54, AxisErrorDetails.HAS_NO_RIGHTS_TO_EDIT_PARAMS_OF_ACCOUNT_ID2,
                                account.getAccountID()), new AccountMap(account));
    }
}
