package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.SmsNotificationInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 09.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@RunWith(Parameterized.class)
public class GetUpdateSmsEmailInfoTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String NOTIFICATION_EMAIL = "test" + RandomStringUtils.randomAlphabetic(5) + "@test.com";

    @Parameterized.Parameters
    public static Collection roleValues() {
        Object[][] data = new Object[][]{
                {FinanceLogins.AGENCY_TRANSFER_1, FinanceLogins.TRANSFER_CLIENT_1},
                {Logins.MANAGER_DEFAULT, FinanceLogins.SERVICED_CLIENT1},
                {FinanceLogins.GET_UPDATE_CLIENT_1, FinanceLogins.GET_UPDATE_CLIENT_1},
                {FinanceLogins.INVOICE_FREE_CLIENT, FinanceLogins.INVOICE_FREE_CLIENT},
        };
        return Arrays.asList(data);
    }

    public GetUpdateSmsEmailInfoTest(String managerLogin, String clientLogin) {
        api.as(managerLogin);
        this.clientLogin = clientLogin;
    }

    private String clientLogin;
    private Account account;

    @BeforeClass
    public static void initTest() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.addModeratedCampaign(FinanceLogins.SERVICED_CLIENT1);
        api.userSteps.financeSteps().verifySharedAccount(FinanceLogins.SERVICED_CLIENT1);
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_TRANSFER_1);
        api.as(FinanceLogins.AGENCY_TRANSFER_1).userSteps.createAccount(FinanceLogins.TRANSFER_CLIENT_1);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.GET_UPDATE_CLIENT_1);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
    }

    @Before
    public void getAccountInfo() {
        account = api.userSteps.financeSteps().getAccount(clientLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6125")
    public void notChangeMoneyInSms() {
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        smsNotificationInfo.setMoneyInSms(null);
        log.info("AccountManagement.Update не меняет поле MoneyInSms");
        assertThat(((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))).getSmsNotification().getMoneyInSms(),
                equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6126")
    public void notChangeMoneyOutSms() {
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        String moneyOutSms = smsNotificationInfo.getMoneyOutSms();
        smsNotificationInfo.setMoneyOutSms(null);
        log.info("AccountManagement.Update не меняет поле MoneyInSms");
        assertThat(((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))).getSmsNotification().getMoneyInSms(),
                equalTo(moneyOutSms));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6127")
    public void changeMetricaSmsIsImpossible() {
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        String metricaSms = smsNotificationInfo.getMetricaSms();
        smsNotificationInfo.setMetricaSms(RandomStringUtils.randomAlphabetic(10));
        log.info("AccountManagement.Update не меняет поле MetricaSms");
        assertThat(((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))).getSmsNotification().getMetricaSms(),
                equalTo(metricaSms));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6128")
    public void changeModerateResultSmsIsImpossible() {
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        String moderateResultSms = smsNotificationInfo.getModerateResultSms();
        smsNotificationInfo.setModerateResultSms(RandomStringUtils.randomAlphabetic(10));
        log.info("AccountManagement.Update не меняет поле ModerateResultSms");
        assertThat(((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))).getSmsNotification().getMetricaSms(),
                equalTo(moderateResultSms));
    }
}
