package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.SmsEmailChangeUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.EmailNotificationInfo;
import ru.yandex.autotests.directapi.common.api45.SmsNotificationInfo;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 09.10.13
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@RunWith(Parameterized.class)
public class GetUpdateSmsEmailInfoTestFailed {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String NOTIFICATION_EMAIL = "test" + RandomStringUtils.randomAlphabetic(5) + "@test.com";

    @Parameterized.Parameters
    public static Collection roleValues() {
        Object[][] data = new Object[][]{
                {FinanceLogins.AGENCY_TRANSFER_1, FinanceLogins.TRANSFER_CLIENT_1},
                {Logins.MANAGER_DEFAULT, FinanceLogins.SERVICED_CLIENT1},
                {FinanceLogins.GET_UPDATE_CLIENT_1, FinanceLogins.GET_UPDATE_CLIENT_1},
                {FinanceLogins.INVOICE_FREE_CLIENT, FinanceLogins.INVOICE_FREE_CLIENT},
        };
        return Arrays.asList(data);
    }

    public GetUpdateSmsEmailInfoTestFailed(String managerLogin, String clientLogin) {
        api.as(managerLogin);
        this.clientLogin = clientLogin;
    }

    private String clientLogin;
    private Account account;

    @BeforeClass
    public static void initTest() {
        api.as(Logins.SUPER_LOGIN);
        api.userSteps.addModeratedCampaign(FinanceLogins.SERVICED_CLIENT1);
        api.userSteps.financeSteps().verifySharedAccount(FinanceLogins.SERVICED_CLIENT1);
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_TRANSFER_1);
        api.as(FinanceLogins.AGENCY_TRANSFER_1).userSteps.createAccount(FinanceLogins.TRANSFER_CLIENT_1);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.GET_UPDATE_CLIENT_1);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
    }

    @Before
    public void getAccountInfo() {
        account = api.userSteps.financeSteps().getAccount(clientLogin);
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6129")
    public void changeSmsTimeTo() {
        //DIRECT-29310
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        smsNotificationInfo.setSmsTimeTo(SmsEmailChangeUtils.changeTimeTo(smsNotificationInfo.getSmsTimeTo()));
        log.info("AccountManagement.Update меняет поле SmsTimeTo: " + smsNotificationInfo.getSmsTimeTo());
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6130")
    public void changeSmsTimeFrom() {
        //DIRECT-29310
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        smsNotificationInfo.setSmsTimeFrom(SmsEmailChangeUtils.changeTimeFrom(smsNotificationInfo.getSmsTimeFrom()));
        log.info("AccountManagement.Update меняет поле SmsTimeFrom: " + smsNotificationInfo.getSmsTimeFrom());
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6131")
    public void changeMoneyInOutSmsToYes() {
        //DIRECT-29310
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        smsNotificationInfo.setMoneyInSms(Value.YES);
        smsNotificationInfo.setMoneyOutSms(Value.YES);
        log.info("AccountManagement.Update меняет поля MoneyInSms и MoneyOutSms на: Yes");
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6132")
    public void changeMoneyInOutSmsToNo() {
        //DIRECT-29310
        SmsNotificationInfo smsNotificationInfo = account.getSmsNotification();
        smsNotificationInfo.setMoneyInSms(Value.NO);
        smsNotificationInfo.setMoneyOutSms(Value.NO);
        log.info("AccountManagement.Update меняет поля MoneyInSms и MoneyOutSms на: No");
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6133")
    public void changeNotificationEmail() {
        //DIRECT-29310
        EmailNotificationInfo emailNotificationInfo = account.getEmailNotification();
        emailNotificationInfo.setEmail(NOTIFICATION_EMAIL);
        log.info("AccountManagement.Update меняет поле NotificationEmail: " + emailNotificationInfo.getEmail());
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }

    @Test
    @Title("Bug DIRECT-29310")
    @ru.yandex.qatools.allure.annotations.TestCaseId("6134")
    public void changeMoneyWarningValue() {
        //DIRECT-29310
        EmailNotificationInfo emailNotificationInfo = account.getEmailNotification();
        emailNotificationInfo.setMoneyWarningValue(emailNotificationInfo.getMoneyWarningValue() + 1);
        log.info("AccountManagement.Update меняет поле MoneyWarningValue: " + emailNotificationInfo
                .getMoneyWarningValue());
        assertThat(JsonUtils.toString((Account) api.userSteps.financeSteps()
                        .updateAccountAndReturnUpdated(new AccountMap(account))),
                equalTo(JsonUtils.toString(account)));
    }
}
