package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 14.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class SmsMoneyInTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static String login = FinanceLogins.INVOICE_FREE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.as(login).userSteps.addModeratedCampaign(login);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(login);
        api.as(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6138")
    public void undefMoneyInAfterYes() {
        api.userSteps.financeSteps().setAccountMoneyIn(login, Value.YES);
        Account account = api.userSteps.financeSteps().setAccountMoneyIn(login, null);
        assertThat(account.getSmsNotification().getMoneyInSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6137")
    public void undefMoneyInAfterNo() {
        api.userSteps.financeSteps().setAccountMoneyIn(login, Value.NO);
        Account account = api.userSteps.financeSteps().setAccountMoneyIn(login, null);
        assertThat(account.getSmsNotification().getMoneyInSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6135")
    public void turnOffMoneyIn() {
        api.userSteps.financeSteps().setAccountSmsMoney(login, Value.YES, Value.NO);
        Account account = api.userSteps.financeSteps().setAccountMoneyIn(login, Value.NO);
        assertThat(account.getSmsNotification().getMoneyInSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6136")
    public void turnOnMoneyIn() {
        api.userSteps.financeSteps().setAccountMoneyIn(login, Value.NO);
        Account account = api.userSteps.financeSteps().setAccountMoneyIn(login, Value.YES);
        assertThat(account.getSmsNotification().getMoneyInSms(), equalTo(Value.YES));

    }
}
