package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 14.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class SmsMoneyOutTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static String login = FinanceLogins.INVOICE_SC_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(FinanceLogins.AGENCY_INVOICE_1);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_INVOICE_1);
        api.userSteps.createAccount(login);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6139")
    public void undefMoneyOutAfterYes() {
        api.userSteps.financeSteps().setAccountMoneyOut(login, Value.YES);
        Account account = api.userSteps.financeSteps().setAccountMoneyOut(login, null);
        assertThat(account.getSmsNotification().getMoneyOutSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6140")
    public void undefMoneyOutAfterNo() {
        api.userSteps.financeSteps().setAccountMoneyOut(login, Value.NO);
        Account account1 = api.userSteps.financeSteps().setAccountMoneyIn(login, Value.NO);
        Account account = api.userSteps.financeSteps().setAccountMoneyOut(login, null);
        assertThat(account.getSmsNotification().getMoneyOutSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6141")
    public void turnOffMoneyOut() {
        api.userSteps.financeSteps().setAccountSmsMoney(login, Value.NO, Value.YES);
        Account account = api.userSteps.financeSteps().setAccountMoneyOut(login, Value.NO);
        assertThat(account.getSmsNotification().getMoneyOutSms(), equalTo(Value.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6142")
    public void turnOnMoneyOut() {
        api.userSteps.financeSteps().setAccountMoneyOut(login, Value.NO);
        Account account = api.userSteps.financeSteps().setAccountMoneyOut(login, Value.YES);
        assertThat(account.getSmsNotification().getMoneyOutSms(), equalTo(Value.YES));

    }
}
