package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.SmsEmailChangeUtils;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.SmsNotificationInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: rockman
 * Date: 13.11.13
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class UpdateAccountTwiceInOneRequest {

    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String AGENCY_LOGIN = FinanceLogins.AGENCY_TRANSFER_1;
    private static final String CLIENT_LOGIN = FinanceLogins.TRANSFER_CLIENT_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    private Account account1;
    private Account account2;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_TRANSFER_1);
        api.as(FinanceLogins.AGENCY_TRANSFER_1).userSteps.createAccount(FinanceLogins.TRANSFER_CLIENT_1);
    }

    @Before
    public void getAccountInfo() {
        account1 = api.userSteps.financeSteps().getAccount(CLIENT_LOGIN);
        account2 = api.userSteps.financeSteps().getAccount(CLIENT_LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6143")
    public void updateTwice() {
        SmsNotificationInfo smsNotificationInfo1 = account1.getSmsNotification();
        smsNotificationInfo1.setSmsTimeTo(SmsEmailChangeUtils.changeTimeTo(smsNotificationInfo1.getSmsTimeTo()));
        SmsNotificationInfo smsNotificationInfo2 = account2.getSmsNotification();
        smsNotificationInfo2.setSmsTimeFrom(SmsEmailChangeUtils.changeTimeTo(smsNotificationInfo2.getSmsTimeFrom()));

        api.userSteps.financeSteps().update(new AccountMap(account1), new AccountMap(account2));
        Account account = api.userSteps.financeSteps().getAccount(CLIENT_LOGIN);
        assertThat(account.getSmsNotification(), equalTo(smsNotificationInfo2));
    }
}
