package ru.yandex.autotests.directapi.finance.accountmanagement.update;

import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.Account;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.AccountMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Author pavryabov
 * Date 10.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.ACCOUNT_MANAGEMENT_GET_UPDATE)
@Tag(TagDictionary.TRUNK)
public class UpdateAccountWithoutCampaigns {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6144")
    public void getErrorRequestWithAccountWithoutCampaignsAgencyCall() {
        api.as(FinanceLogins.AGENCY_TRANSFER_1).wsdl(APIPort_PortType.class);
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createNewAgencySubClient("subClient", FinanceLogins.AGENCY_TRANSFER_1);
        String subclient = createNewSubclientResponse.getLogin();
        long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        int accountID = api.userSteps.financeSteps().enableAndGetSharedAccount(subclient);
        Account account = api.userSteps.financeSteps().getAccount(subclient);
        api.userSteps.campaignSteps().campaignsDelete(subclient, campaignID);
        api.userSteps.financeSteps().shouldGetErrorOnUpdateAccount(
                new AxisError(54, AxisErrorDetails.HAS_NO_RIGHTS_TO_EDIT_PARAMS_OF_ACCOUNT_ID2, accountID),
                new AccountMap<>(account));
    }
}
