package ru.yandex.autotests.directapi.finance.createinvoice;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: pavryabov
 * Date: 24.02.14
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@Tag(TagDictionary.TRUNK)
public class CreateInvoiceBySubClientTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String clientLogin = Logins.API_SUBCLIENT;
    private static long agencyCampaign;
    private static Money minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAPI(clientLogin);
        api.as(Logins.AGENCY_YE_DEFAULT);
        agencyCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        long agencyAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(agencyCampaign, clientLogin);
        api.userSteps.adsSteps().addDefaultTextAd(agencyAdGroupId, clientLogin);
        api.userSteps.campaignFakeSteps().makeCampaignModerated(agencyCampaign);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6201")
    public void expectErrorCreateInvoiceForAgencyCampaign() {
        api.as(Logins.SUPER_LOGIN, clientLogin);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(54, null),
                new PayCampElementMap(api.type())
                        .withCampaignID(agencyCampaign)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceAmount.floatValue())
        );
    }
}
