package ru.yandex.autotests.directapi.finance.createinvoice;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Author pavryabov
 * Date 12.05.14
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
public class CreateInvoiceCurrencyFieldTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String noCurrencyClient = Logins.CLIENT_FREE_YE_DEFAULT;
    private static String currencyClient = Logins.LOGIN_FOR_RUB;
    private static String bynClient = Logins.BYN_CLIENT1;
    private static long campaignIDRUB;
    private static long campaignIDNoCurrency;
    ;

    @BeforeClass
    public static void initTest() {
        campaignIDNoCurrency = api.as(Logins.AGENCY_YE_DEFAULT).userSteps
                .addActiveCampaign(noCurrencyClient, 1);
        api.as(currencyClient);
        campaignIDRUB = api.userSteps.addActiveCampaign(currencyClient, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6211")
    public void expectErrorCreateInvoiceNoCurrencyClientRUBInRequest() {
        api.as(Logins.AGENCY_YE_DEFAULT);
        log.info("Вызываем метод CreateInvoice для кампании невалютного клиента с параметром Currency = RUB");
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245, AxisErrorDetails.NO_VALID_CURRENCY_VALUE),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIDNoCurrency)
                        .withSum(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue())
                        .withCurrency(Currency.RUB));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6213")
    public void createInvoiceRUBClientRUBInRequest() {
        api.as(currencyClient);
        log.info("Вызываем метод CreateInvoice для кампании рублевого клиента с параметром Currency = RUB");
        String url = api.userSteps.financeSteps().createInvoice(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIDRUB)
                        .withSum(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue())
                        .withCurrency(Currency.RUB));
        log.info("Вызов метода завершился успешно. Счет доступен по адресу" + url);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6214")
    public void expectErrorCreateInvoiceRUBClientUSDInRequest() {
        api.as(currencyClient);
        log.info("Вызываем метод CreateInvoice для кампании рублевог клиента с параметром Currency = USD");
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.RUB.toString()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIDRUB)
                        .withSum(MoneyCurrency.get(Currency.USD).getMinInvoiceAmount().addVAT().floatValue())
                        .withCurrency(Currency.USD));
    }

    @Test
    public void expectErrorCreateInvoiceBYNClientRUBInRequest() {
        api.as(bynClient);
        long campaignIdByn = api.userSteps.addActiveCampaign(bynClient, 1);
        log.info("Вызываем метод CreateInvoice для кампании белорусского клиента с параметром Currency = RUB");
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.BYN.toString()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIdByn)
                        .withSum(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT().floatValue())
                        .withCurrency(Currency.RUB));
    }
}
