package ru.yandex.autotests.directapi.finance.createinvoice;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@RunWith(Parameterized.class)
@Description("Проверка запрета оплаты кампании помощью метода CreateInvoice в гривнах")
@Issue("https://st.yandex-team.ru/DIRECT-66515")
public class CreateInvoiceCurrencyUAHNegativeTest {

    private static final String agencyLogin = Logins.AGENCY_UAH;
    private static final String subclientLogin = Logins.SUBCLIENT_UAH;
    private static final String clientLogin = Logins.LOGIN_FOR_UAH;
    private static final float randomPaymentAmount = 1000.0f;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long subclientCampaignId;
    private static Long clientCampaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public Currency currency;

    private LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameters()
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {null},
                {Currency.UAH},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.as(agencyLogin);
        subclientCampaignId = api.userSteps.addModeratedCampaign(subclientLogin);

        api.as(clientLogin);
        clientCampaignId = api.userSteps.addModeratedCampaign(clientLogin);
    }

    @Test
    public void testSubclientInvoice() {
        String curr = currency != null ? currency.toString() : null;
        log.info("Вызываем метод CreateInvoice для украинского cубклиента. Currency " + curr);
        api.as(agencyLogin).userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245),
                new PayCampElementMap(api.type())
                        .withCampaignID(subclientCampaignId)
                        .withSum(randomPaymentAmount)
                        .withCurrency(currency));
    }

    @Test
    public void testClientInvoice() {
        String curr = currency != null ? currency.toString() : null;
        log.info("Вызываем метод CreateInvoice для украинского клиента. Currency " + curr);
        api.as(clientLogin).userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245),
                new PayCampElementMap(api.type())
                        .withCampaignID(clientCampaignId)
                        .withSum(randomPaymentAmount)
                        .withCurrency(currency));
    }
}
