package ru.yandex.autotests.directapi.finance.createinvoice;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(FinanceFeatures.CREATE_INVOICE)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями для чужого логина.")
@RunWith(Parameterized.class)
public class CreateInvoiceForNonTextCampaignRightsTest {
    private static final String ANOTHER_CLIENT = Logins.CLIENT_DOT_LOGIN;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(FinanceLogins.TRANSFER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static long nonTextCampaignId;
    private static long textCampaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.CPM_BANNER},
                {CampaignsType.CPM_DEALS},
        });
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns() {
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(nonTextCampaignId);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(textCampaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6223")
    public void createInvoiceOfNonTextCampaign() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
        api.as(ANOTHER_CLIENT).userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(54),
                new PayCampElementMap(api.type())
                        .withCampaignID(nonTextCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(20f)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6224")
    public void createInvoiceOfNonTextAndTextCampaign() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
        api.as(ANOTHER_CLIENT).userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(54),
                new PayCampElementMap(api.type())
                        .withCampaignID(nonTextCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(20f),
                new PayCampElementMap(api.type())
                        .withCampaignID(textCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(30f)
        );
    }
}
