package ru.yandex.autotests.directapi.finance.createinvoice;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.CreateInvoiceInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(FinanceFeatures.CREATE_INVOICE)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class CreateInvoiceForNonTextCampaignTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(FinanceLogins.TRANSFER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long nonTextCampaignId;
    private static long textCampaignId;

    @Rule
    public Trashman trasher = new Trashman(api);
    private String response;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.DYNAMIC},
                {CampaignsType.CPM_BANNER},
                {CampaignsType.CPM_DEALS},
        });
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns() {
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(nonTextCampaignId);
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(textCampaignId);
    }

    @Before
    public void setType() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6225")
    public void createInvoiceOfNonTextCampaign() {
        response = api.userSteps.financeSteps().createInvoice(
                new CreateInvoiceInfoMap(api.type())
                        .withPayments(
                                new PayCampElementMap(api.type())
                                        .withCampaignID(nonTextCampaignId)
                                        .withCurrency(Currency.RUB)
                                        .withSum(MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT())
                        )
        );
        assertThat("вернулся верный ответ", response.isEmpty(), equalTo(false));
    }

    @Issue("DIRECT-44427")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6226")
    public void createInvoiceOfNonTextAndTextCampaign() {
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(366),
                new PayCampElementMap(api.type())
                        .withCampaignID(nonTextCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(20f),
                new PayCampElementMap(api.type())
                        .withCampaignID(textCampaignId)
                        .withCurrency(Currency.RUB)
                        .withSum(30f)
        );
    }
}
