package ru.yandex.autotests.directapi.finance.createinvoice;


import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: pavryabov
 * Date: 30.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@RunWith(Parameterized.class)
public class CreateInvoiceMassShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String clientFirstShard;

    @Parameterized.Parameter(value = 2)
    public String clientSecondShard;

    @Parameterized.Parameter(value = 3)
    public Currency currency;

    @Parameterized.Parameters(name = "Operator = {0}, Client = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Logins.AGENCY_SHARD_2, Logins.SUBCLIENT_SHARD_1, Logins.SUBCLIENT_SHARD, Currency.RUB},
        };
        return Arrays.asList(data);
    }

    public long campaignIDFirstShard;
    public long campaignIDSecondShard;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.AGENCY_SHARD_2, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(Logins.SUBCLIENT_SHARD_1, ShardNumbers.DEFAULT_SHARD);
    }

    @Before
    public void initTest() {
        api.as(Logins.SUPER_LOGIN, operator);
        campaignIDFirstShard = api.userSteps.campaignSteps().addDefaultTextCampaign(clientFirstShard);
        campaignIDSecondShard = api.userSteps.campaignSteps().addDefaultTextCampaign(clientSecondShard);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6230")
    public void createInvoiceTest() {
        Money sum = MoneyCurrency.get(currency).getMinInvoiceAmount();
        String requestID = api.userSteps.financeSteps().getRequestID(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIDFirstShard)
                        .withCurrency(currency)
                        .withSum(sum.addVAT().floatValue()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignIDSecondShard)
                        .withCurrency(currency)
                        .withSum(sum.addVAT().floatValue()));
        api.userSteps.balanceSteps().operator(User.get(operator)).requestAmountShouldBe(
                requestID, equalTo(sum.multiply(2f).convert(Currency.RUB).addVAT().floatValue()));
    }
}
