package ru.yandex.autotests.directapi.finance.createinvoice;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;

/**
 * Author pavryabov
 * Date 14.05.14
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CreateInvoiceMinCurrencyValueTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Currency currency;
    private long campaignID;
    private Money invoiceSum;

    @Parameterized.Parameter(value = 0)
    public String client;

    @Parameterized.Parameters(name = "Client = {0}")
    public static Collection clients() {
        Object[][] data = new Object[][]{
// DIRECT-66511                {Logins.LOGIN_FOR_UAH},
                {Logins.LOGIN_FOR_KZT}, // DIRECT-65042
                {Logins.LOGIN_FOR_EUR},
                {Logins.LOGIN_FOR_CHF},
// DIRECT-130518    {Logins.LOGIN_FOR_TRY}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(client);
        currency = Currency.getFor(
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client)).getClientCurrencies()[0]);
        campaignID = api.userSteps.addActiveCampaign(client, 1);
        invoiceSum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT()
                .setScale(2, RoundingMode.HALF_UP);
    }

    //по мотивам https://jira.yandex-team.ru/browse/DIRECT-23462
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6231")
    public void createInvoiceWithMinSum() {
        Money sum = invoiceSum.subtract(0.0001f);
        log.info("Вызываем метод CreateInvoice для валютного клиента с параметром Currency = " + currency.toString());
        String requestID = api.userSteps.financeSteps().getRequestID(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(sum.floatValue())
                        .withCurrency(currency));
        api.userSteps.balanceSteps().operator(User.get(client)).requestAmountShouldBe(
                requestID, equalTo(sum.setScale(RoundingMode.HALF_UP).floatValue()));
    }
}
