package ru.yandex.autotests.directapi.finance.createinvoice;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CreateInvoiceYFTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignID;
    private Money invoiceSum;

    @Parameterized.Parameter(value = 0)
    public String client;

    @Parameterized.Parameters(name = "Client = {0}")
    public static Collection clients() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_KZT},
                {Logins.LOGIN_FOR_EUR},
                {Logins.LOGIN_FOR_CHF},
                {Logins.LOGIN_FOR_TRY}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(client);
        Currency currency = Currency.getFor(
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(client)).getClientCurrencies()[0]);
        campaignID = api.userSteps.addActiveCampaign(client, 1);
        invoiceSum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT()
                .setScale(2, RoundingMode.HALF_UP);
    }

    @Test
    public void createInvoiceWithYndFixedCurrencyTest() {
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(invoiceSum.floatValue())
                        .withCurrency(Currency.YND_FIXED));
    }

    @Test
    public void createInvoiceWithNoCurrencyTest() {
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withSum(invoiceSum.floatValue()));
    }

    @Test
    public void createInvoiceWithNullCurrencyTest() {
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withCurrency("NULL")
                        .withSum(invoiceSum.floatValue()));
    }
}
