package ru.yandex.autotests.directapi.finance.createinvoice;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;

/**
 * User: mariabye
 * Date: 24.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CurrencyValidateRubTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);
    @Parameterized.Parameter(value = 0)
    public String operatorLogin;
    @Parameterized.Parameter(value = 1)
    public String login;
    @Parameterized.Parameter(value = 2)
    public String balanceLogin;
    Money minInvoiceSumRUBWithoutVAT = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount();
    Money minInvoiceSumRUB = minInvoiceSumRUBWithoutVAT.addVAT();
    Money minInvoiceSumNoCurrency = MoneyCurrency.get(null).getMinInvoiceAmount().addVAT(Currency.RUB);
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @Parameterized.Parameters(name = "Operator = {0}, Login = {1} ")
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {FinanceLogins.AGENCY_INVOICE_1, FinanceLogins.INVOICE_SC_1, FinanceLogins.AGENCY_INVOICE_1},
                {FinanceLogins.INVOICE_FREE_CLIENT, FinanceLogins.INVOICE_FREE_CLIENT,
                        FinanceLogins.INVOICE_FREE_CLIENT},
                {FinanceLogins.AGENCY_INVOICE_2, FinanceLogins.INVOICE_SC_3, FinanceLogins.AGENCY_INVOICE_2},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(FinanceLogins.AGENCY_INVOICE_1);
        api.as(FinanceLogins.AGENCY_INVOICE_1).userSteps.createAccount(FinanceLogins.INVOICE_SC_1);
        api.as(FinanceLogins.INVOICE_FREE_CLIENT).userSteps.addModeratedCampaign(FinanceLogins.INVOICE_FREE_CLIENT);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().verifySharedAccount(FinanceLogins.INVOICE_FREE_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6243")
    public void rubCurrency() {
        api.as(operatorLogin);
        long campaignID = api.userSteps.addDraftCampaign(login);
        String requestID = api.userSteps.financeSteps().getRequestID(
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSumRUB.floatValue())
        );
        api.userSteps.balanceSteps().operator(User.get(balanceLogin))
                .requestAmountShouldBe(requestID, equalTo(minInvoiceSumRUB.floatValue()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6244")
    public void noRightCurrency() {
        api.as(operatorLogin);
        long campaignID = api.userSteps.addDraftCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245, AxisErrorDetails.VALID_CURRENCY_VALUE_IS, Currency.RUB.toString()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withCurrency(Currency.USD)
                        .withSum(MoneyCurrency.get(Currency.USD).getMinInvoiceAmount().floatValue())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6249")
    public void usdAndRUBCurrency() {
        api.as(operatorLogin);
        long campaignID1 = api.userSteps.addDraftCampaign(login);
        long campaignID2 = api.userSteps.addDraftCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(245, AxisErrorDetails.ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSumRUB.floatValue()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withCurrency(Currency.USD)
                        .withSum(MoneyCurrency.get(Currency.USD).getMinInvoiceAmount().floatValue())
        );
    }
}


