package ru.yandex.autotests.directapi.finance.createinvoice;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.finances.CreateInvoiceInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.notNullValue;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 27.02.14
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
public class PaymentTokenJSONHeaderTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String clientWithFinOperations = FinanceLogins.FREE_CLIENT_OVERDRAFT2;
    private static String clientWithoutFinOperations = FinanceLogins.CLIENT_WITH_DISABLED_FIN_OPERATIONS;
    private static long campaignID1;
    private static long campaignID2;
    private static Money minInvoiceAmount = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();

    @BeforeClass
    public static void initTest() {
        api.as(clientWithFinOperations);
        campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignID1);
        api.as(clientWithoutFinOperations);
        campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignID2);
    }

    String createInvoice(CreateInvoiceInfoMap invoice, boolean paymentTokenAUTH) {
        if (paymentTokenAUTH) {
            api.userSteps.financeSteps().setYMFinanceOAUTH();
        } else {
            api.userSteps.financeSteps().setDirectFinanceOAUTH(Method.CREATE_INVOICE);
        }
        try {
            return api.userSteps.financeSteps().jsonClient().invokeMethod(Method.CREATE_INVOICE, invoice.getBean());
        } finally {
            api.userSteps.financeSteps().clearFinanceOAUTH();
        }
    }

    //@Test до починки ЯД DIRECT-65926
    @ru.yandex.qatools.allure.annotations.TestCaseId("6256")
    public void createInvoiceWithPaymentTokenFinanceEnabled() {
        api.as(clientWithFinOperations);
        CreateInvoiceInfoMap createInvoiceInfoMap = new CreateInvoiceInfoMap(api.type())
                .withPayments(new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceAmount.floatValue()));
        String url = createInvoice(createInvoiceInfoMap, true);
        assertThat("Счет успешно выставлен", url, notNullValue());
    }

//    @Test
//    public void createInvoiceWithPaymentTokenFinanceDisabled() {
//        api.as(clientWithoutFinOperations);
//        CreateInvoiceInfoMap createInvoiceInfoMap = new CreateInvoiceInfoMap(api.type())
//                .withPayments(new PayCampElementMap(api.type())
//                        .withCampaignID(campaignID2)
//                        .withSum(minInvoiceAmount.floatValue()));
//        String url = createInvoice(createInvoiceInfoMap, true);
//        assertThat("Счет успешно выставлен", url, notNullValue());
//    }ToDo broken payment token - DIRECT-41294

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6257")
    public void createInvoiceWithFinanceTokenFinanceEnabled() {
        api.as(clientWithFinOperations);
        CreateInvoiceInfoMap createInvoiceInfoMap = new CreateInvoiceInfoMap(api.type())
                .withPayments(new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceAmount.floatValue()));
        String url = createInvoice(createInvoiceInfoMap, false);
        assertThat("Счет успешно выставлен", url, notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6258")
    public void createInvoiceWithFinanceTokenFinanceDisabled() {
        api.as(clientWithoutFinOperations);
        CreateInvoiceInfoMap createInvoiceInfoMap = new CreateInvoiceInfoMap(api.type())
                .withPayments(new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceAmount.floatValue()));
        api.userSteps.financeSteps().setDirectFinanceOAUTH(Method.CREATE_INVOICE);
        try {
            api.userSteps.financeSteps().shouldGetErrorOn(
                    "Успешное выставление счета при запрещенных финансовых операциях",
                    Method.CREATE_INVOICE, createInvoiceInfoMap, new AxisError(352, null));
        } finally {
            api.userSteps.financeSteps().clearFinanceOAUTH();
        }
    }
}
