package ru.yandex.autotests.directapi.finance.createinvoice;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * User: mariabye
 * Date: 24.10.13
 */
@Aqua.Test
@Features(FinanceFeatures.CREATE_INVOICE)
public class SumForNoAccountValidateTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final Money minInvoiceSum = MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().addVAT();

    private static final String operatorLogin = Logins.AGENCY_RUB;
    private static final String login = Logins.SUBCLIENT_RUB_1;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6271")
    public void zeroSum() {
        api.as(operatorLogin);
        long campaignID = api.userSteps.addModeratedCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(354, AxisErrorDetails.INVALID_AMOUNT_SPECIFIED_FOR_CAMPAIGN, campaignID),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withCurrency(Currency.RUB)
                        .withSum(0f)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6270")
    public void lowSum() {
        api.as(operatorLogin);
        long campaignID = api.userSteps.addModeratedCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(354, AxisErrorDetails.LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_CUSTOM,
                        MoneyCurrency.get(Currency.RUB).getMinTransferRest()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        Currency.RUB.value().toLowerCase(), campaignID),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSum.getPrevious().floatValue()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6272")
    public void lowAndNormalSum() {
        api.as(operatorLogin);
        long campaignID1 = api.userSteps.addModeratedCampaign(login);
        long campaignID2 = api.userSteps.addModeratedCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(354, AxisErrorDetails.LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_CUSTOM,
                        MoneyCurrency.get(Currency.RUB).getMinTransferRest()
                                .stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                        Currency.RUB.value().toLowerCase(), campaignID1),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSum.getPrevious().floatValue()),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSum.getNext().floatValue())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6273")
    public void zeroAndNormalSum() {
        api.as(operatorLogin);
        long campaignID1 = api.userSteps.addModeratedCampaign(login);
        long campaignID2 = api.userSteps.addModeratedCampaign(login);
        api.userSteps.financeSteps().shouldGetErrorOnCreateInvoice(
                new AxisError(354, AxisErrorDetails.INVALID_AMOUNT_SPECIFIED_FOR_CAMPAIGN, campaignID1),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID1)
                        .withCurrency(Currency.RUB)
                        .withSum(0f),
                new PayCampElementMap(api.type())
                        .withCampaignID(campaignID2)
                        .withCurrency(Currency.RUB)
                        .withSum(minInvoiceSum.getNext().floatValue()));
    }
}
