package ru.yandex.autotests.directapi.finance.enablesharedaccount;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.finance.FinanceLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientRightMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.EnableSharedAccountRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 24.12.2014.
 * <p/>
 * https://st.yandex-team.ru/DIRECT-37620
 */
@Aqua.Test
@Features(FinanceFeatures.ENABLE_SHARED_ACCOUNT)
@RunWith(Parameterized.class)
public class EnableSharedAccountAndClientRightsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static final String agency = FinanceLogins.AGENCY_BALANCE_ACCOUNT;
    private static String subClient;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String allowEditCampaign;

    @Parameterized.Parameter(value = 1)
    public String allowTransferMoney;

    @Parameterized.Parameters(name = "edit = {0}, transfer = {1}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {Value.NO, Value.NO},
                {Value.NO, Value.YES},
                {Value.YES, Value.NO},
                {Value.YES, Value.YES}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareSubClient() {
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agency);
        api.userSteps.clientFakeSteps().enableAgencyWallet(agency);
        CreateNewSubclientResponse response =
                api.as(agency).userSteps.clientSteps().createNewAgencySubClient("at-sc-right-", agency, Currency.RUB);
        subClient = response.getLogin();
    }

    @Before
    public void updateRights() {
        api.as(agency).userSteps.clientSteps().updateClientRights(subClient,
                new ClientRightMap(api.type()).allowEditCampaign(allowEditCampaign),
                new ClientRightMap(api.type()).allowTransferMoney(allowTransferMoney),
                new ClientRightMap(api.type()).allowImportXls(Value.NO)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6274")
    public void subClientAccountEnableHimselfTest() {
        api.as(Logins.SUPER_LOGIN, subClient).userSteps.financeSteps().shouldGetErrorOn(
                Method.ENABLE_SHARED_ACCOUNT,
                new EnableSharedAccountRequestMap(api.type()).withLogins(subClient).getBean(),
                new AxisError(54, AxisErrorDetails.FOR_AGENCY_ONLY));
    }
}
