package ru.yandex.autotests.directapi.finance.enablesharedaccount;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.finances.sharedaccount.EnableSharedAccountRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * User: mariabye
 * Date: 05.11.13
 */
@Aqua.Test
@Features(FinanceFeatures.ENABLE_SHARED_ACCOUNT)
public class NoRightRolesTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    public static String agencyLogin = Logins.AGENCY_ANOTHER;
    public static String managerLogin = Logins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void sharedAccountFlagOn() {
        api.userSteps.clientFakeSteps().disableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6301")
    public void managerHasNoRight() {
        api.wsdl(ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType.class).as(managerLogin);
        ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createServicedClient("sh", managerLogin);
        api.userSteps.financeSteps().shouldGetErrorOn(
                Method.ENABLE_SHARED_ACCOUNT,
                new EnableSharedAccountRequestMap(api.type()).withLogins(subClient.getLogin()),
                new AxisError(54, AxisErrorDetails.FOR_AGENCY_ONLY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6300")
    public void clientHasNoRight() {
        String clientLogin = api.wsdl(ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType.class)
                .as(managerLogin).userSteps.createFreeClient("free-sh");
        api.as(Logins.SUPER_LOGIN, clientLogin);
        api.userSteps.financeSteps().shouldGetErrorOn(
                Method.ENABLE_SHARED_ACCOUNT,
                new EnableSharedAccountRequestMap(api.type()).withLogins(clientLogin),
                new AxisError(54, AxisErrorDetails.FOR_AGENCY_ONLY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6302")
    public void clientHasNoRightAgencyWalletAgencySupportAccount() {
        api.wsdl(APIPort_PortType.class).userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.as(agencyLogin);
        CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createNewAgencySubClient("sh", agencyLogin, Currency.RUB);
        api.userSteps.clientFakeSteps().enableAPI(subClient.getLogin());
        api.userSteps.addDraftCampaign(subClient.getLogin());
        api.as(Logins.SUPER_LOGIN, subClient.getLogin()).userSteps.financeSteps().shouldGetErrorOn(
                Method.ENABLE_SHARED_ACCOUNT,
                new EnableSharedAccountRequestMap(api.type()).withLogins(subClient.getLogin()),
                new AxisError(54, AxisErrorDetails.FOR_AGENCY_ONLY));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6303")
    public void clientHasNoRightAgencyWalletAgencyNotSupportAccount() {
        api.wsdl(APIPort_PortType.class).as(agencyLogin);
        CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createNewAgencySubClient("sh", agencyLogin, Currency.RUB);
        api.userSteps.clientFakeSteps().enableAPI(subClient.getLogin());
        api.userSteps.addDraftCampaign(subClient.getLogin());
        api.as(Logins.SUPER_LOGIN, subClient.getLogin()).userSteps.financeSteps().shouldGetErrorOn(
                Method.ENABLE_SHARED_ACCOUNT,
                new EnableSharedAccountRequestMap(api.type()).withLogins(subClient.getLogin()),
                new AxisError(54, AxisErrorDetails.FOR_AGENCY_ONLY));
    }
}
