package ru.yandex.autotests.directapi.finance.enablesharedaccount;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;


/**
 * User: buhter
 * Date: 10.12.15
 * https://st.yandex-team.ru/TESTIRT-7970
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-49066")
@Features(FinanceFeatures.ENABLE_SHARED_ACCOUNT)
public class NotEnabledSharedAccountOnCampaignCreationTest {
    public static String agencyLogin = Logins.AGENCY_ANOTHER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void sharedAccountFlagOn() {
        api.userSteps.clientFakeSteps().disableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9635")
    public void createFirstCampaignV5() {
        api.wsdl(APIPort_PortType.class).as(agencyLogin);
        CreateNewSubclientResponse subClient = api.userSteps.clientSteps()
                .createNewAgencySubClient("sh", agencyLogin, Currency.RUB);
        Long cid = api.userSteps.campaignSteps().addDefaultTextCampaign(subClient.getLogin());
        assertThat("ОС не подключился",
                api.userSteps.campaignFakeSteps().fakeGetCampaignParams(cid.intValue()).getWalletCid(), equalTo(0));
    }

}
