package ru.yandex.autotests.directapi.finance.getcreditlimits;


import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.CreditLimitsInfo;
import ru.yandex.autotests.directapi.common.api45.PayCampElement;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: pavryabov
 * Date: 31.01.14
 * <p>
 * https://jira.yandex-team.ru/browse/TESTIRT-1452
 */
@Aqua.Test
@Features(FinanceFeatures.GET_CREDIT_LIMITS)
@Stories(ApiStories.SHARDING)
public class GetCreditLimitsShardingTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    public static String agencyLogin = Logins.AGENCY_IN_2_SHARD;
    public static String clientLogin = Logins.SUB_IN_2_SHARD;
    public long campaignID;
    public Currency currency = null;
    public String contractID;

    @BeforeClass
    public static void reshard() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agencyLogin, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(clientLogin, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    public void initTest() {
        api.as(Logins.SUPER_LOGIN, agencyLogin);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        String[] currencyString =
                ((ClientInfo) api.userSteps.clientSteps().getClientInfo(clientLogin)).getClientCurrencies();
        if (currencyString != null) {
            currency = Currency.getFor(currencyString[0]);
        }
        User user = User.get(agencyLogin);
        api.userSteps.balanceSteps().withIgnoreDuplicatePersons(true);
        user.resetBalanceContractInfos();
        contractID = user.getExternalContractID();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6352")
    public void getCreditLimitsContractIDTest() {
        assertThat("Неверный номер контракта",
                ((CreditLimitsInfo) api.userSteps.financeSteps().getCreditLimits()).getLimits()[0].getContractID(),
                equalTo(contractID));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6353")
    public void getCreditLimitsSumTest() {
        api.userSteps.campaignSteps().bin.removeFromBin(campaignID);
        Money sum = MoneyCurrency.get(currency).getMinInvoiceAmount().addVAT();
        Money contractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(contractID);
        api.userSteps.financeSteps().payCampaigns(new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(contractID)
                .withPayments(new PayCampElementMap<>(new PayCampElement())
                        .withCampaignID(campaignID)
                        .withCurrency(currency)
                        .withSum(sum.floatValue())));
        Money contractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(contractID);
        assertThat("Неверный остаток контракта", contractSpentAfterPayment,
                equalTo(contractSpentBeforePayment.add(sum.subtractVAT().convert(Currency.RUB).addVAT())));
    }
}
