package ru.yandex.autotests.directapi.finance.getcreditlimits;


import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.CreditLimitsInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.finances.PayCampElementMap;
import ru.yandex.autotests.directapi.model.finances.PayCampaignsInfoMap;
import ru.yandex.autotests.directapi.model.finances.PayMethod;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.test.ClientIdLock;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * User: mariabye
 * Date: 12.09.11
 */
@Aqua.Test
@Features(FinanceFeatures.GET_CREDIT_LIMITS)
public class GetCreditLimitsSumTest {
    private static final String AGENCY_LOGIN = Logins.AGENCY_RUB;
    private static final String CLIENT_LOGIN = Logins.SUBCLIENT_RUB_4;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static ClientIdLock lock;

    private static String[] externalContractdIDs;

    private static long campaignID;
    private static long campaignIDElse;
    private static Money sumPay = MoneyCurrency.get(Currency.RUB).getMinTransferAmount().addVAT();

    @BeforeClass
    public static void initTest() {
        lock = new ClientIdLock("CreditLimits" + AGENCY_LOGIN);
        lock.acquire(3);
        campaignID = api.userSteps.addDraftCampaign(CLIENT_LOGIN);
        campaignIDElse = api.userSteps.addDraftCampaign(CLIENT_LOGIN);
        api.userSteps.balanceSteps().withIgnoreDuplicatePersons(true);
        externalContractdIDs = User.get(AGENCY_LOGIN).getExternalContractIDs();
    }

    @AfterClass
    public static void releaseLock() {
        lock.release();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6354")
    public void payWithContract() {
        Money contractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money contractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        assertThat("Неверный остаток контракта", contractSpentAfterPayment,
                equalTo(contractSpentBeforePayment.add(
                        sumPay.bigDecimalValue()))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6355")
    public void getCreditLimitsCurrencyTest() {
        CreditLimitsInfo creditLimitsInfo = api.userSteps.financeSteps().getCreditLimits();
        assertThat("Валюта в ответе отличается от ожидаемой",
                creditLimitsInfo.getCurrency(), equalTo(Currency.RUB.toString()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6356")
    public void checkRestOtherContract() {
        Money contractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money contractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток контракта", contractSpentAfterPayment, equalTo(contractSpentBeforePayment));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6357")
    public void testGetLimitsSpentTwoPay() {
        Money firstContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money firstContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток первого контракта", firstContractSpentAfterPayment,
                equalTo(firstContractSpentBeforePayment
                        .add(sumPay.multiply(2f).bigDecimalValue())));
        assertThat("Неверный остаток второго контракта",
                secondContractSpentAfterPayment, equalTo(secondContractSpentBeforePayment));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6358")
    public void testGetLimitsSpentOnePayTwoCampaign() {
        Money firstContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue()),
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money firstContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток первого контракта", firstContractSpentAfterPayment,
                equalTo(firstContractSpentBeforePayment.add(sumPay.multiply(2f).bigDecimalValue())));
        assertThat("Неверный остаток второго контракта",
                secondContractSpentAfterPayment, equalTo(secondContractSpentBeforePayment));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6359")
    public void testGetLimitsSpentTwoPayTwoCampaign() {
        Money firstContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money firstContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток первого контракта", firstContractSpentAfterPayment,
                equalTo(firstContractSpentBeforePayment
                        .add(sumPay.multiply(2f).bigDecimalValue())));
        assertThat("Неверный остаток второго контракта",
                secondContractSpentAfterPayment, equalTo(secondContractSpentBeforePayment));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6360")
    public void testGetTwoLimitsSpentTwoPay() {
        Money firstContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[1])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money firstContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток первого контракта", firstContractSpentAfterPayment,
                equalTo(firstContractSpentBeforePayment
                        .add(sumPay.bigDecimalValue())));
        assertThat("Неверный остаток второго контракта", secondContractSpentAfterPayment,
                equalTo(secondContractSpentBeforePayment
                        .add(sumPay.bigDecimalValue())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6361")
    public void testGetTwoLimitsSpentTwoPayTwoCampaign() {
        Money firstContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentBeforePayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        PayCampaignsInfoMap payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[0])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignID)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        payCampaignsInfoMap = new PayCampaignsInfoMap(api.type())
                .withPayMethod(PayMethod.BANK)
                .withContractID(externalContractdIDs[1])
                .withPayments(
                        new PayCampElementMap(api.type())
                                .withCampaignID(campaignIDElse)
                                .withCurrency(Currency.RUB)
                                .withSum(sumPay.floatValue())
                );
        api.userSteps.financeSteps().payCampaigns(payCampaignsInfoMap);
        Money firstContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[0]);
        Money secondContractSpentAfterPayment = api.userSteps.financeSteps().getContractSpent(externalContractdIDs[1]);
        assertThat("Неверный остаток первого контракта", firstContractSpentAfterPayment,
                equalTo(firstContractSpentBeforePayment
                        .add(sumPay.bigDecimalValue())));
        assertThat("Неверный остаток второго контракта", secondContractSpentAfterPayment,
                equalTo(secondContractSpentBeforePayment
                        .add(sumPay.bigDecimalValue())));
    }
}
