package ru.yandex.autotests.directapi.finance.getcreditlimits;


import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.CreditLimitsInfo;
import ru.yandex.autotests.directapi.finance.FinanceFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;

/**
 * Author pavryabov
 * Date 16.04.14
 */
@Aqua.Test
@Features(FinanceFeatures.GET_CREDIT_LIMITS)
public class GetCreditLimitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    public String loginWithDot = Logins.CLIENT_DOT_LOGIN;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6362")
    public void getCreditLimitsWithDotInLogin() {
        CreditLimitsInfo creditLimitsInfo = api.as(loginWithDot).userSteps.financeSteps().getCreditLimits();
        assertThat(creditLimitsInfo.getLimits(), notNullValue());
    }

//    @Test
//    public void getCreditLimitsWithPaymentToken() {
//        CreditLimitsInfo creditLimitsInfo =
//                api.as(Logins.AGENCY_YE_DEFAULT).userSteps.financeSteps().getCreditLimitsWithPaymentToken();
//        assertThat(creditLimitsInfo.getLimits(), notNullValue());
//    }ToDo broken payment token - DIRECT-41294
}
