package ru.yandex.autotests.directapi.finance.movelogin;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.clients.ClientInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 19.05.2015.
 * https://st.yandex-team.ru/TESTIRT-5544
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@RunWith(Parameterized.class)
@Description("Проверка возможности переноса средств между кампаниями от имени агентсва/менеджера. Используем при проверке задач переноса логинов")
public class TransferMoneyByAssistantTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static Money sum = MoneyCurrency.get(Currency.USD).getMinTransferAmount();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    //private static int campaignIdTo;

    @Parameterized.Parameter(value = 0)
    public String operator;

    @Parameterized.Parameter(value = 1)
    public String client;

    @Parameterized.Parameter(value = 2)
    public long campaignIdFrom;

    @Parameterized.Parameter(value = 3)
    public long campaignIdTo;

    @Parameterized.Parameters(name = "operator = {0}, client = {1}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {Logins.AGENCY_YE_DEFAULT, Logins.API_SUBCLIENT, 123, 1234}
                /*
                {"tripadvisor-mcc", "krystyna-johnson", 8877241, 8874978},
                {"tripadvisor-mcc", "tripadvisor-ad", 8874978, 8877241},
                {"tripadvisor-mcc", "tripadvisor-ukraine", 8877241, 9832336},
                {"tripadvisor-mcc", "tripadvisor-ua-cont", 8877241, 8665240},
                */
        });
    }

    @Before
    public void createCampaigns() {
        api.as(Logins.SUPER_LOGIN, operator);
        //необходимо учитывать наличие подключенного ОС
        //campaignIdTo = api.userSteps.createModeratedCampaign(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6364")
    public void transferMoneyTest() {
        api.as(Logins.SUPER_LOGIN, operator);

        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(client);
        clientInfo.getClientRights()[0].setValue(Value.NO);
        clientInfo.getClientRights()[1].setValue(Value.YES);
        clientInfo.getClientRights()[2].setValue(Value.NO);
        api.userSteps.clientSteps().updateClientInfo(new ClientInfoMap<>(clientInfo));

        CampaignGetItem campaignFrom = api.userSteps.campaignSteps().getCampaigns(campaignIdFrom).get(0);
        CampaignGetItem campaignTo = api.userSteps.campaignSteps().getCampaigns(campaignIdTo).get(0);

        api.userSteps.financeSteps().transferMoney(campaignIdFrom, campaignIdTo, sum.floatValue(), Currency.USD);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignFrom, sum.negate()));
        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps()
                .campaignFundsChangedOnFunds(campaignTo, sum));
    }
}
